#install.packages('expm')
library(expm)
library(MASS)

##########
# inputs #
##########

id= scan('/Users/bladt/Library/Mobile Documents/com~apple~CloudDocs/Software/Programming/Diffusions/Multivariate/id.dat')

dim = id[1]
id_seq = seq(2,dim*2*(dim+1)+1)
x0 = x = B = sig = vector()
for(i in id_seq[1:dim]){x0 = c(x0,id[i])}
x0 = matrix(x0,dim,1)
id_seq = id_seq[-(1:dim)]
for(i in id_seq[1:dim]){x = c(x,id[i])}
x = matrix(x,dim,1)
id_seq = id_seq[-(1:dim)]
for(i in id_seq[1:(dim*dim)]){B = c(B,id[i])}
B = matrix(B,dim,dim,byrow=T)
id_seq = id_seq[-(1:(dim*dim))]
for(i in id_seq[1:(dim*dim)]){sig = c(sig,id[i])}
sig = det(matrix(sig,dim,dim,byrow=T))
n = id[dim*2*(dim+1)+2]
t = id[dim*2*(dim+1)+4]/id[dim*2*(dim+1)+3]
flag = id[dim*2*(dim+1)+5]

Gt = sig*0.5*solve(B)%*%(diag(1,dim)-expm(-2*B*t))
G1 = sig*0.5*solve(B)%*%(diag(1,dim)-expm(-2*B))
F = expm(-B*t)
F1 = expm(-B)

MM = F%*%x0 + F%*%Gt%*%solve(G1)%*%(x-F1%*%x0)
MC = Gt - F%*%Gt%*%solve(G1)%*%Gt%*%F

MC = as.matrix(MC)
MM = as.vector(MM)
d_sim = as.data.frame(mvrnorm(n,MM,MC))

############
# metric D #
############

x = as.vector(read.table('/Users/bladt/Library/Mobile Documents/com~apple~CloudDocs/Software/Programming/Diffusions/Multivariate/mcmc.dat'))
nd = dim(x)[1]
y = matrix(NA,nd,1)
MCI = solve(MC)
for(i in 1:nd) {
y[i] = as.matrix(x[i,] - MM)%*%MCI%*%t(x[i,] - MM)
}
y =sort(y)
M = 100
df = dim
p = seq(0,1,1/M)
A_j = qchisq(p, df)

count_y = rep(0,M)

for(i in 1:M){
count_y[i] = length(y[y<A_j[i+1]])-length(y[y<A_j[i]])
}

D = sqrt((1/M)*sum((((count_y/nd)-1/M)^2)))
D


################
# level curves #
################

library(lmomco)
library(copBasic)

d_ap = read.table('/Users/mogensbladt1/Library/Mobile Documents/com~apple~CloudDocs/Software/Programming/Diffusions/Multivariate/mcmc.dat')
path = "/Users/mogensbladt1/Library/Mobile Documents/com~apple~CloudDocs/Software/Programming/Diffusions/Multivariate/qq.pdf"

if (flag==3){
# simulation vs approx #
pdf(path)

for(i in 1:dim){

data1<-d_ap[,i]
sim1<-d_sim[,i]
q1<-quantile(sim1, probs= seq(0.001,0.999,0.001))
q2<-quantile(data1,probs= seq(0.001,0.999,0.001))

nq=length(qq1)
sum=0.0
for(j in 1:nq){
	diffq=abs(q1[j]-q2[j])
	diffq=0.001*diffq
	sum=sum+diffq
}
nm=sum

name1 = paste("Dim-",i,sep="")
name2 = paste("D statistic   = ",round(D,6),sep="   ","Area statistic   =",format(round(nm, 4), nsmall = 3))
plot(q1,q2,xlab="Exact bridge",ylab="Approximate bridge",main=name1)
abline(0,1)
mtext(name2, side=1, line=4)
}
dev.off()
}

if(flag==2){
# simulation vs pseudo MH #

pdf(path)

for(i in 1:dim){
data1<-d_ap[,i]
sim1<-d_sim[,i]
q1<-quantile(sim1, probs= seq(0.001,0.999,0.001))
q2<-quantile(data1,probs= seq(0.001,0.999,0.001))

nq=length(qq1)
sum=0.0
for(j in 1:nq){
	diffq=abs(q1[j]-q2[j])
	diffq=0.001*diffq
	sum=sum+diffq
}
nm=sum

name1 = paste("Dim-",i,sep="")
name2 = paste("D statistic= ",round(D,6),sep="  ","Area statistic   =",format(round(nm, 4), nsmall = 3))
plot(q1,q2,xlab="Exact bridge",ylab="Pseudo MH bridge",main=name1)
abline(0,1)
mtext(name2, side=1, line=4)
}

dev.off()
}

if(flag==1){
# simulation vs mcmc #

pdf(path)
for(i in 1:dim){

data1<-d_ap[,i]
sim1<-d_sim[,i]
q1<-quantile(sim1, probs= seq(0.001,0.999,0.001))
q2<-quantile(data1,probs= seq(0.001,0.999,0.001))

nq=length(qq1)
sum=0.0
for(j in 1:nq){
	diffq=abs(q1[j]-q2[j])
	diffq=0.001*diffq
	sum=sum+diffq
}
nm=sum

name1 = paste("Dim-",i,sep="")
name2 = paste("D statistic = ",round(D,8),sep="   ","Area statistic   =",format(round(nm, 4), nsmall = 3))
plot(q1,q2,xlab="Exact bridge",ylab="MCMC bridge",main=name1)
abline(0,1)
mtext(name2, side=1, line=4)
}
dev.off()
}
